/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

//'use strict';
define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore'

],
	function (Portal, Backbone, Marionette, $, _) {
				var toggleArrow = function (e) {
					$(e.currentTarget).toggleClass('wc-arrow-r').toggleClass('wc-arrow-d').parent().next('.wc-dd').toggleClass('wc-hidden');
				};
				var infoTip = function () {
					var targets = $('[rel~=tooltip]'),
						title = false,
						tip,
						oldTip,
						lastTarget,
						open = false,
						that = this;
					this.target = undefined;
					var handleTooltip = function (target) {
						if (isCurrentTooltipOpen(target.attr('id'))) {
							remove_tooltip();
							return;
						}
						if (isTooltipOpen()) {
							remove_tooltip();
						}
						that.target = target;
						lastTarget = target;
						tip = target.attr('title');
						oldTip = tip;
						var tooltip = $('<div id="tooltip"></div>');
						that.tooltip = tooltip;
						if (!tip || tip === '')
							return false;

						target.removeAttr('title');
						tooltip.attr('targetid',target.attr('id'));
						tooltip.bind('click.close', remove_tooltip);
						tooltip.css('opacity', 0)
							.html(tip)
							.appendTo('body');

						var init_tooltip = function () {

							if ($(window).width() < tooltip.outerWidth() * 1.5)
								tooltip.css('max-width', $(window).width() / 2);
							else
								tooltip.css('max-width', 340);

							var pos_left = target.offset().left + ( target.outerWidth() / 2 ) - ( tooltip.outerWidth() / 2 ),
								pos_top = target.offset().top - tooltip.outerHeight() - 20;

							if (pos_left < 0) {
								pos_left = target.offset().left + target.outerWidth() / 2 - 20;
								tooltip.addClass('left');
							}
							else
								tooltip.removeClass('left');

							if (pos_left + tooltip.outerWidth() > $(window).width()) {
								pos_left = target.offset().left - tooltip.outerWidth() + target.outerWidth() / 2 + 20;
								tooltip.addClass('right');
							}
							else
								tooltip.removeClass('right');

							if (pos_top < 0) {
								pos_top = target.offset().top + target.outerHeight();
								tooltip.addClass('top');
							}
							else
								tooltip.removeClass('top');

							tooltip.css({ left: pos_left, top: pos_top })
								.animate({ top: '+=10', opacity: 1 }, 50);
						};

						init_tooltip();
						$(window).resize(init_tooltip);
					};

					//mouse events were firing in android, so to prevent it from happening in any device I only allow them in desktop
					if( !/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
						targets.bind('mouseleave.open', function () {
							handleTooltip($(this));
						});
						targets.bind('mouseenter.open', function () {
							handleTooltip($(this));
						});
					}


					targets.bind('click.open', function(e) {
						if (!open)
							handleTooltip($(this));
					});
					var isCurrentTooltipOpen = function(id) {
						return $('#tooltip').attr('targetid') === id;
					};
					var remove_tooltip = function () {
						// get tooltip if open and not set on the 'that' variable
						if (typeof that.tooltip === 'undefined')
							that.tooltip = $('#tooltip');
						that.tooltip.animate({ top: '-=10', opacity: 0 }, 50, function () {
							$(this).remove();
						});
						oldTip = undefined;
						lastTarget = undefined;
						that.target.attr('title', tip);
					};
					var isTooltipOpen = function() {
						return $('#tooltip').length > 0;
					};
					var isClickOnTooltipButton = function(e) {
						if (e.target.getAttribute('id'))
							return e.target.getAttribute('id').indexOf('-info') >= 0;
						else
							return false;
					};
					var checkClickOnDoc = function(e) {
						if (!isClickOnTooltipButton(e) && isTooltipOpen()) {
							remove_tooltip();
						}
					};
					$(document).on('click.notOnPopup', checkClickOnDoc);
				};
		return {infoTip:infoTip,toggleArrow:toggleArrow};
	});
